
$(document).ready(function() {

    check_amount(parseFloat($('#total_amount').val())); 

    $(document).on('click','.checkbox_field',function(){
        
        var amount = parseFloat($('#total_amount').val());
        var charge = parseFloat($(this).attr("data-charges"));
        var result_amount = parseFloat($(this).attr("data-resultamount"));
        var display_result_amount = parseFloat($.trim($('#display_result_amount').html().replace(",", "").replace("$", "")));
        
        if($(this).is(":checked"))
        {
           
            total_amount = amount + charge;
          
            var final_result_amount = display_result_amount + result_amount;
            if ($('.checkbox_result_amount').is(":checked")) 
            {

                total_amount = total_amount + result_amount;
            }
        }
        else
        {
            
            total_amount = amount - charge;
           
            var final_result_amount = display_result_amount - result_amount;
           
            if ($('.checkbox_result_amount').is(":checked")) 
            {
                total_amount = total_amount.toFixed(2) - result_amount;
            }
        }

        $('#display_result_amount').text(final_result_amount.toFixed(2));

        check_amount(total_amount); 

    });
        

    $(document).on('click','.checkbox_result_amount',function(){
       
        var display_result_amount = parseFloat($.trim($('#display_result_amount').html().replace(",", "").replace("$", "")));
        var total_amount = parseFloat($('#total_amount').val());

        if ($(this).is(":checked")) 
        {
            var final_amount = total_amount + display_result_amount;
        }
        else
        {
            var final_amount = total_amount - display_result_amount;
        }

        check_amount(final_amount);

    });


    $(document).on('change','#duration',function(){
         
        var duration = $('#duration').val();
        var service_id = $('#service_id').val();
        
        if(duration != '' && service_id != '')
        {
            $.ajax({
                url: base_url+'dashboard/filter_products', // point to server-side controller method
                data: {
                    duration:duration,
                    service_id:service_id
                },
                type: 'post',
                dataType:'html',
                success: function (response) {
                    if(response)
                    {
                        $('#subject_list').html(response);
                        $('#total_cost').text('0.00');
                        $('#total_amount').val('0.00');
                        $('#display_result_amount').text('0.00');
                        
                        // coupon code
                        $('#coupon_status').val('no');
				        $('#apply_coupon').show();
				        $('#is_applied').html('');
				        $('#coupon_code').attr('readonly', false);

                        check_amount(Number('0.00')); //give number bcoz of passing value 0.00 is not accept .toFixed(2) function 
                        

                    }
                },
            });
        }

    });


    function check_amount(final_amount) 
    {
        $('#total_cost').text(final_amount.toFixed(2));
        $('#total_amount').val(final_amount.toFixed(2));

        if (final_amount <= 0) 
        {
            $('#buy').attr('disabled',true);
        }
        else
        {
            $('#buy').attr('disabled',false);
        }
        var coupon_status = $('#coupon_status').val();
        if (coupon_status == 'yes') 
        {
        	apply_coupon_ajax();
        }
        

    }

    $(document).on('click','#apply_coupon',function(){
        apply_coupon_ajax();
    });


    function apply_coupon_ajax()
    {
    	var duration = $('#duration').val();
        var coupon_code = $('#coupon_code').val();
        
        if(duration != '' && coupon_code != '')
        {
            $.ajax({
                url: base_url+'dashboard/apply_coupon_ajax', // point to server-side controller method
                data: {
                    duration:duration,
                    coupon_code:coupon_code
                },
                type: 'post',
                // dataType:'json',
                success: function (response) {
                    if(response)
                    {
                        var result = JSON.parse(response);
                        if (result.status == 'true') 
                        {
                        	charges_array = [];
                        	result_amount_array = [];
                        	// $("input:checkbox[class=checkbox_field]:checked").each(function(){
                        	$('.checkbox_field:checkbox:checked').each(function(){
							    charges_array.push(parseFloat($(this).attr("data-charges")));
							    result_amount_array.push(parseFloat($(this).attr("data-resultamount")));
							});

							var total_amount = charges_array.reduce(function(a, b){
														        return a + b;
														    }, 0);

							if ($('.checkbox_result_amount').is(":checked")) 
				            {
				                var total_result_amount = result_amount_array.reduce(function(a, b){
																		        return a + b;
																		    }, 0);
				                total_amount += total_result_amount;
				            }

                            var discount = result.discount;
                            var discount_amount = (total_amount * discount)/100;
                            var final_amount = total_amount - discount_amount;
                            $('#total_cost').text(final_amount.toFixed(2));
                            $('#total_amount').val(final_amount.toFixed(2));
                            $('#apply_coupon').hide();
                            // $('#cancel_coupon').show();
                            $('#coupon_code_error').text('');
                            $('#coupon_code').attr('readonly', true);
                            $('#is_applied').html('');
                            $('#coupon_status').val('yes');
                            $('#is_applied').html('<b style="color:green;">coupon applied <i class="fas fa-check-circle"></i></b>');
                        }
                        else if(result.status == 'already_used')
                        {
                            $('#coupon_status').val('no');
                            $('#coupon_code_error').text('This coupon is already used.');
                        }
                        else
                        {
                            $('#coupon_status').val('no');
                            $('#coupon_code_error').text('Invalid coupon code.');
                        }
                    }
                },
            });
        }
        else
        {
        	$('#coupon_code_error').text('Coupon code is required.');
        }
    }



    // $(document).on('click','#cancel_coupon',function(){

    //     $('#coupon_status').val('no');
    //     $('#apply_coupon').show();
    //     $('#cancel_coupon').hide();
    //     $('#coupon_code').attr('readonly', false);
        
    // });



});