
$(document).ready(function() {

    $(document).on('click','.checkbox_field, .checkbox_field1',function(){
       
        var final_amount = calculation();
        var coupon_code = $('#coupon_code').val();
        if (coupon_code != '') 
        {
            var monthlyCountCheckboxes = $('input:checkbox.checkbox_field1:checked').length
            if (monthlyCountCheckboxes > 0) 
            {
                $('#coupon_code_error').text('');
                apply_coupon_ajax();
            }
            else
            {
                // $('#coupon_status').val('no');
                $('#is_applied').html('');
                $('#coupon_code').attr('readonly', false);
                $('#coupon_code').val('');
                $('#coupon_code_error').text('Coupon code is valid only for monthly test subjects.');
                $('#apply_coupon').show();

                $('#total_cost').text(final_amount.toFixed(2));
                $('#total_amount').val(final_amount.toFixed(2));
                if (final_amount <= 0) 
                {
                    $('#buy').attr('disabled',true);
                }
                else
                {
                    $('#buy').attr('disabled',false);
                }
            }
        }
        else
        {
            $('#total_cost').text(final_amount.toFixed(2));
            $('#total_amount').val(final_amount.toFixed(2));
            
            if (final_amount <= 0) 
            {
                $('#buy').attr('disabled',true);
            }
            else
            {
                $('#buy').attr('disabled',false);
            }
        }
    });


    function calculation()
    {
        var charge = parseFloat($('.checkbox_field').attr("data-charges"));
        
        var countCheckboxes = $('input:checkbox.checkbox_field:checked').length
        
        if (countCheckboxes > 0) 
        {
            var amount = countCheckboxes * charge
            // var total_amount = amount + 70;
            // var gst = (total_amount * 18 )/ 100;
            // var purchase_result_final_amount = total_amount + gst;
            var amount_plus_delivery_charge = amount + 70;   //70 is delivery charge
            var purchase_result_final_amount = amount_plus_delivery_charge;
        }
        else
        {
            var purchase_result_final_amount = 0.00;
        }
       
        charges_array = [];
        
        $('.checkbox_field1:checkbox:checked').each(function(){
            charges_array.push(parseFloat($(this).attr("data-charges")));
        });
        
        var monthly_test_subject_amount = charges_array.reduce(function(a, b){
                                                                return a + b;
                                                            }, 0);
        
        var final_amount = purchase_result_final_amount + monthly_test_subject_amount;

        if (final_amount > 0) 
        {
            $('#buy').attr('disabled',true);
        }
        else
        {
			$('#buy').attr('disabled',true);
        }

        return final_amount;
    }
        

    $(document).on('click','#apply_coupon',function(){

        var monthlyCountCheckboxes = $('input:checkbox.checkbox_field1:checked').length
        if (monthlyCountCheckboxes > 0) 
        {
            $('#coupon_code_error').text('');
            apply_coupon_ajax();
        }
        else
        {
            // $('#coupon_status').val('no');
            $('#coupon_code_error').text('Coupon code is valid only for monthly test subjects.');
        }
        
    });


    function apply_coupon_ajax()
    {
    	var duration = '90';
        var coupon_code = $('#coupon_code').val();
        
        if(duration != '' && coupon_code != '')
        {
            $.ajax({
                url: base_url+'home/apply_coupon_for_get_certificate_ajax', // point to server-side controller method
                data: {
                    duration:duration,
                    coupon_code:coupon_code
                },
                type: 'post',
                // dataType:'json',
                success: function (response) {
                   
                    if(response)
                    {
                        var result = JSON.parse(response);
                        // alert(result.status);
                        if (result.status == 'true') 
                        {
                        	
							var total_amount = calculation();
                            var discount = result.discount;
                            var discount_amount = (total_amount * discount)/100;
                            var final_amount = total_amount - discount_amount;
                            $('#total_cost').text(final_amount.toFixed(2));
                            $('#total_amount').val(final_amount.toFixed(2));

                            $('#apply_coupon').hide();
                            // $('#cancel_coupon').show();
                            $('#coupon_code_error').text('');
                            $('#coupon_code').attr('readonly', true);
                            $('#is_applied').html('');
                            $('#coupon_status').val('yes');
                            $('#is_applied').html('<b style="color:green;">coupon applied <i class="fas fa-check-circle"></i></b>');
                       
                            if (final_amount <= 0) 
                            {
                                $('#buy').attr('disabled',true);
                            }
                            else
                            {
                                $('#buy').attr('disabled',false);
                            }
                        }
                        else if(result.status == 'already_used')
                        {
                            $('#coupon_status').val('no');
                            $('#coupon_code_error').text('This coupon is already used.');
                        }
                        else
                        {
                            $('#coupon_status').val('no');
                            $('#coupon_code_error').text('Invalid coupon code.');
                        }
                    }
                },
            });
        }
        else
        {
        	$('#coupon_code_error').text('Coupon code is required.');
        }
    }



    // $(document).on('click','#cancel_coupon',function(){

    //     $('#coupon_status').val('no');
    //     $('#apply_coupon').show();
    //     $('#cancel_coupon').hide();
    //     $('#coupon_code').attr('readonly', false);
        
    // });



});