/*

Template: Jobber - Job Board HTML5 Template
Author: potenzaglobalsolutions.com
Design and Developed by: potenzaglobalsolutions.com

NOTE: This file contains all scripts for the actual Template.

*/

/*================================================
[  Table of contents  ]
================================================

:: Preloader
:: Menu
:: Tooltip
:: Counter
:: Owl carousel
:: Slickslider
:: Magnific Popup
:: Datetimepicker
:: Select2
:: Range Slider
:: Countdown
:: Scrollbar
:: Back to top

======================================
[ End table content ]
======================================*/
//POTENZA var

( function ($) {
  "use strict";
  var POTENZA = {};

	/*************************
	  Predefined Variables
	*************************/
	
	var $window     = $(window),
    $document       = $(document),
    $body           = $('body'),
    $countdownTimer = $('.countdown'),
    $counter        = $('.counter');
  
	//Check if function exists
	$.fn.exists = function () {
		return this.length > 0;
	};

	/*************************
		Preloader
    *************************/
	
	POTENZA.preloader = function () {
       $("#load").fadeOut();
       $('#pre-loader').delay(0).fadeOut('slow');
	};

	/*************************
		menu
	*************************/
	POTENZA.dropdownmenu = function () {
		if ( $('.navbar').exists() ) {
			$('.dropdown-menu a.dropdown-toggle').on('click', function (e) {
				if ( !$(this).next().hasClass('show') ) {
					$(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
				}
				var $subMenu = $(this).next(".dropdown-menu");
				$subMenu.toggleClass('show');
				
				$(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
					$('.dropdown-submenu .show').removeClass("show");
				});
				return false;
			});
		}
	};

	$(document).ready(function(){
		$('#nav-icon4').on( 'click', function(){
			$(this).toggleClass('open');
		});
	});

	/*************************
		sticky
	*************************/
	POTENZA.isSticky = function () {
		$(window).scroll( function(){
			if ($(this).scrollTop() > 150) {
				$('.header-sticky').addClass('is-sticky');
			} else {
				$('.header-sticky').removeClass('is-sticky');
			}
		});
	};


	/*************************
		tooltip
	*************************/

	$('[data-toggle="tooltip"]').tooltip();
	$('[data-toggle="popover"]').popover()

	/*************************
		counter
	*************************/
	
	POTENZA.counters = function () {
		var counter = jQuery(".counter");
		if (counter.length > 0) {
			$counter.each(function () {
				var $elem = $(this);
				$elem.appear(function () {
					$elem.find('.timer').countTo();
				});
			});
		}
	};

	/*************************
       owl carousel
	*************************/

	POTENZA.carousel = function () {
		var owlslider = jQuery("div.owl-carousel");
		if ( owlslider.length > 0 ) {
			owlslider.each( function () {
			var $this = $(this),
				$items = ($this.data('items')) ? $this.data('items') : 1,
				$loop = ($this.attr('data-loop')) ? $this.data('loop') : true,
				$navdots = ($this.data('nav-dots')) ? $this.data('nav-dots') : false,
				$navarrow = ($this.data('nav-arrow')) ? $this.data('nav-arrow') : false,
				$autoplay = ($this.attr('data-autoplay')) ? $this.data('autoplay') : true,
				$autospeed = ($this.attr('data-autospeed')) ? $this.data('autospeed') : 5000,
				$smartspeed = ($this.attr('data-smartspeed')) ? $this.data('smartspeed') : 1500,
				$autohgt = ($this.data('autoheight')) ? $this.data('autoheight') : false,
				$space = ($this.attr('data-space')) ? $this.data('space') : 30,
				$animateOut = ($this.attr('data-animateOut')) ? $this.data('animateOut') : false;

				$(this).owlCarousel({
					loop: $loop,
					items: $items,
					responsive: {
						0: {
							items: $this.data('xx-items') ? $this.data('xx-items') : 1
						},
						480: {
							items: $this.data('xs-items') ? $this.data('xs-items') : 1
						},
						768: {
							items: $this.data('sm-items') ? $this.data('sm-items') : 2
						},
						980: {
							items: $this.data('md-items') ? $this.data('md-items') : 3
						},
						1200: {
							items: $items
						}
					},
					dots: $navdots,
					autoplayTimeout: $autospeed,
					smartSpeed: $smartspeed,
					autoHeight: $autohgt,
					margin: $space,
					nav: $navarrow,
					navText: ["<i class='fas fa-chevron-left'></i>", "<i class='fas fa-chevron-right'></i>"],
					autoplay: $autoplay,
					autoplayHoverPause: true
				});
			});
		}
	}

	/*************************
        slickslider
	*************************/
	
	POTENZA.slickslider = function () {
		if ( $('.slider-for').exists() ) {
			$('.slider-for').slick({
				slidesToShow: 1,
				slidesToScroll: 1,
				arrows: true,
				asNavFor: '.slider-nav'
			});
			$('.slider-nav').slick({
				slidesToShow: 3,
				slidesToScroll: 1,
				asNavFor: '.slider-for',
				dots: false,
				centerMode: true,
				focusOnSelect: true
			});
		}
	};

	/*************************
		Magnific Popup
	*************************/
	
	POTENZA.mediaPopups = function () {
		if ($(".popup-single").exists() || $(".popup-gallery").exists() || $('.modal-onload').exists() || $(".popup-youtube, .popup-vimeo, .popup-gmaps").exists()) {
			if ($(".popup-single").exists()) {
				$('.popup-single').magnificPopup({
					type: 'image'
				});
			}

			if ( $(".popup-gallery").exists() ) {
				$('.popup-gallery').magnificPopup({
					delegate: 'a.portfolio-img',
					type: 'image',
					tLoading: 'Loading image #%curr%...',
					mainClass: 'mfp-img-mobile',
					gallery: {
						enabled: true,
						navigateByImgClick: true,
						preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
					}
				});
			}
			
			if ( $(".popup-youtube, .popup-vimeo, .popup-gmaps").exists() ) {
				$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
					disableOn: 700,
					type: 'iframe',
					mainClass: 'mfp-fade',
					removalDelay: 160,
					preloader: false,
					fixedContentPos: false
				});
			}
			
			var $modal = $('.modal-onload');
			if ( $modal.length > 0 ) {
				$('.popup-modal').magnificPopup({
					type: 'inline'
				});
				
				$(document).on('click', '.popup-modal-dismiss', function (e) {
					e.preventDefault();
					$.magnificPopup.close();
				});
		
				var elementTarget = $modal.attr('data-target');
				setTimeout(function () {
					$.magnificPopup.open({
						items: {
							src: elementTarget
						},
						type: "inline",
						mainClass: "mfp-no-margins mfp-fade",
						closeBtnInside: !0,
						fixedContentPos: !0,
						removalDelay: 500
					}, 0 )
				}, 1500 );
			}
		}
	}

	/*************************
		datetimepicker
	*************************/
	
	POTENZA.datetimepickers = function () {
		if ( $('.datetimepickers').exists() ) {
			$('#datetimepicker-01, #datetimepicker-02').datetimepicker({
				format: 'L'
			});
			$('#datetimepicker-03, #datetimepicker-04').datetimepicker({
				format: 'LT'
			});
		}
	};

	/*************************
		select2
	*************************/
	
	POTENZA.select2 = function () {
		if ( $('.basic-select').exists() ) {
			var select = jQuery(".basic-select");
			if ( select.length > 0 ) {
				$('.basic-select').select2();
			}
		}
	};

	/*************************
		Range Slider
	*************************/
	
	POTENZA.rangesliders = function () {
		if ( $('.property-price-slider').exists() ) {
			var rangeslider = jQuery(".rangeslider-wrapper");
			$("#property-price-slider").ionRangeSlider({
				type: "double",
				min: 0,
				max: 10000,
				prefix: "$"
			});
		}
	};

	/*************************
	   Countdown
	*************************/
	
	POTENZA.countdownTimer = function () {
		if ($countdownTimer.exists()) {
			$countdownTimer.downCount({
				date: '12/25/2020 12:00:00', // Month/Date/Year HH:MM:SS
				offset: 400
			});
		}
	}

    /*************************
        BgSlider
	*************************/
	
	POTENZA.bgSlider = function () {
		var $bgSlider = $('#bg-slider');
		if ( $bgSlider.exists() ) {
			$("#bg-slider").kenburnsy({
				fullscreen: false
			});
		}
	}

	/*************************
		scrollbar
	*************************/
	
	POTENZA.scrollbar = function () {
		var scrollbar = jQuery(".scrollbar");
		if ( scrollbar.length > 0 ) {

			// Sidebar Scroll
			var scroll_light = jQuery(".scroll_light");
			if ( scroll_light.length > 0 ) {
				$( scroll_light ).niceScroll({
					cursorborder: 0,
					cursorcolor: "rgba(255,255,255,0.25)"
				});
				$(scroll_light).getNiceScroll().resize();
			}
		
			// Chat Scroll
			var scroll_dark = jQuery(".scroll_dark");
			if ( scroll_dark.length > 0 ) {
				$(scroll_dark).niceScroll({
					cursorborder: 0,
					cursorcolor: "rgba(0,0,0,0.1)"
				});
				$(scroll_dark).getNiceScroll().resize();
			}
		}
	}


	/*************************
		Secondary menu
	*************************/
	
	POTENZA.secondarymenu = function () {
		$(".secondary-menu ul li a[href^='#']").on('click', function(e) {

			// prevent default anchor click behavior
			e.preventDefault();

			// store hash
			var hash = this.hash;

			// animate
			$('html, body').animate({
				scrollTop: $(hash).offset().top
			 }, 1000, function(){
				// when done, add hash to url
				// (default click behaviour)
				window.location.hash = hash;
			});
		});
	}


	/*************************
		Back to top
	*************************/
	
	POTENZA.goToTop = function () {
		var $goToTop = $('#back-to-top');
		$goToTop.hide();
		$window.scroll( function () {
			if ( $window.scrollTop() > 100 ) $goToTop.fadeIn();
			else $goToTop.fadeOut();
		});
		
		$goToTop.on("click", function () {
			$('body,html').animate({
				scrollTop: 0
			}, 1000);
			return false;
		});
	}

	/****************************************************
		POTENZA Window load and functions
	****************************************************/
	
	// Window load functions
	$window.on("load", function () {
		POTENZA.preloader();
	});
	
	// Document ready functions
	$document.ready(function () {
		POTENZA.counters(),
		POTENZA.slickslider(),
		POTENZA.datetimepickers(),
		POTENZA.select2(),
		POTENZA.dropdownmenu(),
		POTENZA.isSticky(),
		POTENZA.scrollbar(),
		POTENZA.goToTop(),
		POTENZA.bgSlider(),
		POTENZA.countdownTimer(),
		POTENZA.secondarymenu(),
		POTENZA.mediaPopups(),
		POTENZA.rangesliders(),
		POTENZA.carousel();
	});
})(jQuery);

